/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.s3.util;

import io.confluent.connect.storage.schema.SchemaIncompatibilityType;
import java.util.HashMap;
import java.util.Map;

public final class FileRotationTracker {
    private final Map<String, RotationMetrics> metrics = new HashMap<String, RotationMetrics>();

    public void incrementRotationBySchemaChangeCount(String outputPartition, SchemaIncompatibilityType schemaIncompatibilityType) {
        if (!this.metrics.containsKey(outputPartition)) {
            this.metrics.put(outputPartition, new RotationMetrics());
        }
        this.metrics.get(outputPartition).incrementRotationBySchemaChangeCount(schemaIncompatibilityType);
    }

    public void incrementRotationByFlushSizeCount(String outputPartition) {
        if (!this.metrics.containsKey(outputPartition)) {
            this.metrics.put(outputPartition, new RotationMetrics());
        }
        this.metrics.get(outputPartition).incrementRotationByFlushSizeCount();
    }

    public void incrementRotationByRotationIntervalCount(String outputPartition) {
        if (!this.metrics.containsKey(outputPartition)) {
            this.metrics.put(outputPartition, new RotationMetrics());
        }
        this.metrics.get(outputPartition).incrementRotationByRotationIntervalCount();
    }

    public void incrementRotationByScheduledRotationIntervalCount(String outputPartition) {
        if (!this.metrics.containsKey(outputPartition)) {
            this.metrics.put(outputPartition, new RotationMetrics());
        }
        this.metrics.get(outputPartition).incrementRotationByScheduledRotationIntervalCount();
    }

    public void clear() {
        this.metrics.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, RotationMetrics> metrics : this.metrics.entrySet()) {
            RotationMetrics rotationMetrics = metrics.getValue();
            sb.append("OutputPartition: ");
            sb.append(metrics.getKey());
            sb.append(", RotationByInterval: ");
            sb.append(rotationMetrics.rotationByRotationInterval);
            sb.append(", RotationByScheduledInterval: ");
            sb.append(rotationMetrics.rotationByScheduledRotationInterval);
            sb.append(", RotationByFlushSize: ");
            sb.append(rotationMetrics.rotationByFlushSize);
            sb.append(", RotationByDiffName: ");
            sb.append(rotationMetrics.rotationByDiffName);
            sb.append(", RotationByDiffSchema: ");
            sb.append(rotationMetrics.rotationByDiffSchema);
            sb.append(", RotationByDiffType: ");
            sb.append(rotationMetrics.rotationByDiffType);
            sb.append(", RotationByDiffVersion: ");
            sb.append(rotationMetrics.rotationByDiffVersion);
            sb.append(", RotationByDiffParams: ");
            sb.append(rotationMetrics.rotationByDiffParams);
            sb.append("\n");
        }
        return sb.toString();
    }

    private static final class RotationMetrics {
        int rotationByFlushSize = 0;
        int rotationByRotationInterval = 0;
        int rotationByScheduledRotationInterval = 0;
        int rotationByDiffSchema = 0;
        int rotationByDiffName = 0;
        int rotationByDiffParams = 0;
        int rotationByDiffType = 0;
        int rotationByDiffVersion = 0;

        private RotationMetrics() {
        }

        public void incrementRotationBySchemaChangeCount(SchemaIncompatibilityType schemaIncompatibilityType) {
            switch (schemaIncompatibilityType) {
                case DIFFERENT_NAME: {
                    ++this.rotationByDiffName;
                    break;
                }
                case DIFFERENT_SCHEMA: {
                    ++this.rotationByDiffSchema;
                    break;
                }
                case DIFFERENT_PARAMS: {
                    ++this.rotationByDiffParams;
                    break;
                }
                case DIFFERENT_TYPE: {
                    ++this.rotationByDiffType;
                    break;
                }
                case DIFFERENT_VERSION: {
                    ++this.rotationByDiffVersion;
                    break;
                }
            }
        }

        public void incrementRotationByFlushSizeCount() {
            ++this.rotationByFlushSize;
        }

        public void incrementRotationByRotationIntervalCount() {
            ++this.rotationByRotationInterval;
        }

        public void incrementRotationByScheduledRotationIntervalCount() {
            ++this.rotationByScheduledRotationInterval;
        }
    }
}

