/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.s3.storage;

import io.confluent.connect.s3.storage.ByteBuf;
import java.nio.BufferOverflowException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticByteBuffer
implements ByteBuf {
    private static final Logger log = LoggerFactory.getLogger(ElasticByteBuffer.class);
    public static final int INCREMENT_FACTOR = 1;
    private int capacity;
    private int initPhysicalCap;
    private int position;
    private byte[] buf;

    public ElasticByteBuffer(int capacity, int initPhysicalCap) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity must greater than zero");
        }
        if (initPhysicalCap <= 0) {
            log.debug("initial physical capacity must be greater than zero");
            throw new IllegalArgumentException("initial physical capacity must be greater than zero");
        }
        this.capacity = capacity;
        this.initPhysicalCap = initPhysicalCap;
        this.initialize();
    }

    private void initialize() {
        this.position = 0;
        int initCapacity = Math.min(this.capacity, this.initPhysicalCap);
        this.buf = new byte[initCapacity];
    }

    private void expand() {
        int currSize = this.buf.length;
        int calNewSize = currSize << 1;
        int newSize = 0;
        newSize = calNewSize < currSize ? this.capacity : Math.min(this.capacity, calNewSize);
        byte[] currBuf = this.buf;
        this.buf = new byte[newSize];
        System.arraycopy(currBuf, 0, this.buf, 0, currSize);
    }

    @Override
    public void put(byte b) {
        if (!this.hasRemaining()) {
            throw new BufferOverflowException();
        }
        if (this.physicalRemaining() <= 0) {
            this.expand();
        }
        this.buf[this.position] = b;
        ++this.position;
    }

    @Override
    public void put(byte[] src, int offset, int length) {
        ElasticByteBuffer.checkBounds(offset, length, src.length);
        if (this.remaining() < length) {
            throw new BufferOverflowException();
        }
        int remainingOffset = offset;
        int remainingLen = length;
        while (true) {
            if (this.physicalRemaining() <= 0) {
                this.expand();
            }
            if (this.physicalRemaining() >= remainingLen) {
                System.arraycopy(src, remainingOffset, this.buf, this.position, remainingLen);
                this.position += remainingLen;
                break;
            }
            int physicalRemaining = this.physicalRemaining();
            System.arraycopy(src, remainingOffset, this.buf, this.position, physicalRemaining);
            this.position += physicalRemaining;
            remainingOffset += physicalRemaining;
            remainingLen -= physicalRemaining;
        }
    }

    static void checkBounds(int off, int len, int size) {
        if ((off | len | off + len | size - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    public int physicalRemaining() {
        return this.buf.length - this.position;
    }

    @Override
    public boolean hasRemaining() {
        return this.capacity > this.position;
    }

    @Override
    public int remaining() {
        return this.capacity - this.position;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public void clear() {
        if (this.buf.length <= this.initPhysicalCap) {
            this.position = 0;
        } else {
            this.initialize();
        }
    }

    @Override
    public final byte[] array() {
        return this.buf;
    }
}

