/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.s3.format;

import io.confluent.connect.s3.S3SinkConnectorConfig;
import io.confluent.connect.s3.util.Utils;
import io.confluent.connect.storage.format.RecordWriter;
import io.confluent.connect.storage.format.RecordWriterProvider;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueHeaderRecordWriterProvider
implements RecordWriterProvider<S3SinkConnectorConfig> {
    private static final Logger log = LoggerFactory.getLogger(KeyValueHeaderRecordWriterProvider.class);
    @Nullable
    private final RecordWriterProvider<S3SinkConnectorConfig> valueProvider;
    @Nullable
    private final RecordWriterProvider<S3SinkConnectorConfig> keyProvider;
    @Nullable
    private final RecordWriterProvider<S3SinkConnectorConfig> headerProvider;

    public KeyValueHeaderRecordWriterProvider(RecordWriterProvider<S3SinkConnectorConfig> valueProvider, @Nullable RecordWriterProvider<S3SinkConnectorConfig> keyProvider, @Nullable RecordWriterProvider<S3SinkConnectorConfig> headerProvider) {
        this.valueProvider = Objects.requireNonNull(valueProvider);
        this.keyProvider = keyProvider;
        this.headerProvider = headerProvider;
    }

    public String getExtension() {
        return this.valueProvider.getExtension();
    }

    public RecordWriter getRecordWriter(final S3SinkConnectorConfig conf, final String filename) {
        String strippedFilename = filename.endsWith(this.valueProvider.getExtension()) ? filename.substring(0, filename.length() - this.valueProvider.getExtension().length()) : filename;
        final Optional valueWriter = filename.contains(conf.getTombstoneEncodedPartition()) ? Optional.empty() : Optional.of(this.valueProvider.getRecordWriter((Object)conf, strippedFilename));
        final Optional<RecordWriter> keyWriter = Optional.ofNullable(this.keyProvider).map(keyProvider -> keyProvider.getRecordWriter((Object)conf, strippedFilename));
        final Optional<RecordWriter> headerWriter = Optional.ofNullable(this.headerProvider).map(headerProvider -> headerProvider.getRecordWriter((Object)conf, strippedFilename));
        return new RecordWriter(){

            public void write(SinkRecord sinkRecord) {
                if (conf.isTombstoneWriteEnabled() && !keyWriter.isPresent()) {
                    throw new ConnectException("Key Writer must be configured when writing tombstone records is enabled.");
                }
                if (keyWriter.isPresent() && sinkRecord.key() == null) {
                    throw new DataException(String.format("Key cannot be null for SinkRecord: %s", Utils.sinkRecordToLoggableString(sinkRecord)));
                }
                if (headerWriter.isPresent() && (sinkRecord.headers() == null || sinkRecord.headers().isEmpty())) {
                    throw new DataException(String.format("Headers cannot be null for SinkRecord: %s", Utils.sinkRecordToLoggableString(sinkRecord)));
                }
                if (valueWriter.isPresent()) {
                    ((RecordWriter)valueWriter.get()).write(sinkRecord);
                } else if (sinkRecord.value() != null) {
                    throw new ConnectException(String.format("Value writer not configured for SinkRecord: %s. fileName: %s, tombstonePartition: %s", Utils.sinkRecordToLoggableString(sinkRecord), filename, conf.getTombstoneEncodedPartition()));
                }
                keyWriter.ifPresent(writer -> writer.write(sinkRecord));
                headerWriter.ifPresent(writer -> writer.write(sinkRecord));
            }

            public void close() {
                valueWriter.ifPresent(RecordWriter::close);
                keyWriter.ifPresent(RecordWriter::close);
                headerWriter.ifPresent(RecordWriter::close);
            }

            public void commit() {
                valueWriter.ifPresent(RecordWriter::commit);
                keyWriter.ifPresent(RecordWriter::commit);
                headerWriter.ifPresent(RecordWriter::commit);
            }
        };
    }
}

