/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.storage.util;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;

public class DateTimeUtils {
    public static long getNextTimeAdjustedByDay(long currentTimeMs, long periodMs, DateTimeZone timeZone) {
        DateTime currentDT = new DateTime(currentTimeMs).withZone(timeZone);
        DateTime startOfDayDT = currentDT.withTimeAtStartOfDay();
        DateTime startOfNextDayDT = startOfDayDT.plusDays(1);
        Duration currentDayDuration = new Duration((ReadableInstant)startOfDayDT, (ReadableInstant)startOfNextDayDT);
        long todayInMs = currentDayDuration.getMillis();
        long startOfDay = startOfDayDT.getMillis();
        long nextPeriodOffset = ((currentTimeMs - startOfDay) / periodMs + 1L) * periodMs;
        long offset = Math.min(nextPeriodOffset, todayInMs);
        return startOfDay + offset;
    }
}

