/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.storage.util;

import io.confluent.connect.storage.common.util.StringUtils;
import java.util.Map;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.DataException;

public class DataUtils {
    public static Object getField(Object structOrMap, String fieldName) {
        DataUtils.validate(structOrMap, fieldName);
        if (!(structOrMap instanceof Struct)) {
            if (structOrMap instanceof Map) {
                Object field = ((Map)structOrMap).get(fieldName);
                if (field == null) {
                    throw new DataException(String.format("Unable to find nested field '%s'", fieldName));
                }
                return field;
            }
            throw new DataException(String.format("Argument not a Struct or Map. Cannot get field '%s'.", fieldName));
        }
        Object field = ((Struct)structOrMap).get(fieldName);
        if (field == null) {
            throw new DataException(String.format("The field '%s' does not exist.", fieldName));
        }
        return field;
    }

    public static Object getNestedFieldValue(Object structOrMap, String fieldName) {
        DataUtils.validate(structOrMap, fieldName);
        try {
            Object innermost = structOrMap;
            for (String name : fieldName.split("\\.")) {
                innermost = DataUtils.getField(innermost, name);
            }
            return innermost;
        }
        catch (DataException e) {
            throw new DataException(String.format("The field '%s' does not exist.", fieldName), (Throwable)e);
        }
    }

    public static Field getNestedField(Schema schema, String fieldName) {
        DataUtils.validate(schema, fieldName);
        String[] fieldNames = fieldName.split("\\.");
        try {
            Field innermost = schema.field(fieldNames[0]);
            for (int i = 1; i < fieldNames.length; ++i) {
                innermost = innermost.schema().field(fieldNames[i]);
            }
            return innermost;
        }
        catch (DataException e) {
            throw new DataException(String.format("Unable to get field '%s' from schema %s.", fieldName, schema), (Throwable)e);
        }
    }

    private static void validate(Object o, String fieldName) {
        if (o == null) {
            throw new ConnectException("Attempted to extract a field from a null object.");
        }
        if (StringUtils.isBlank((String)fieldName)) {
            throw new ConnectException("The field to extract cannot be null or empty.");
        }
    }
}

