/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.storage.schema;

import io.confluent.connect.storage.schema.SchemaCompatibility;
import io.confluent.connect.storage.schema.SchemaCompatibilityResult;
import io.confluent.connect.storage.schema.SchemaIncompatibilityType;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaProjector;
import org.apache.kafka.connect.errors.SchemaProjectorException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.source.SourceRecord;

public enum StorageSchemaCompatibility implements SchemaCompatibility
{
    NONE{

        @Override
        public SourceRecord project(SourceRecord record, Schema currentKeySchema, Schema currentValueSchema) {
            return record;
        }

        @Override
        public SinkRecord project(SinkRecord record, Schema currentKeySchema, Schema currentValueSchema) {
            return record;
        }

        @Override
        protected SchemaCompatibilityResult check(Schema originalSchema, Schema currentSchema) {
            boolean isInCompatible = !originalSchema.equals(currentSchema);
            SchemaIncompatibilityType schemaIncompatibilityType = isInCompatible ? SchemaIncompatibilityType.DIFFERENT_SCHEMA : SchemaIncompatibilityType.NA;
            return new SchemaCompatibilityResult(isInCompatible, schemaIncompatibilityType);
        }
    }
    ,
    BACKWARD,
    FORWARD{

        @Override
        protected SchemaCompatibilityResult checkVersions(Schema originalSchema, Schema currentSchema) {
            boolean isInCompatible = originalSchema.version().compareTo(currentSchema.version()) < 0;
            SchemaIncompatibilityType schemaIncompatibilityType = isInCompatible ? SchemaIncompatibilityType.DIFFERENT_VERSION : SchemaIncompatibilityType.NA;
            return new SchemaCompatibilityResult(isInCompatible, schemaIncompatibilityType);
        }
    }
    ,
    FULL;

    private static final Map<String, StorageSchemaCompatibility> REVERSE;
    private static final Set<AbstractMap.SimpleImmutableEntry<Schema.Type, Schema.Type>> PROMOTABLES;

    public static StorageSchemaCompatibility getCompatibility(String name) {
        StorageSchemaCompatibility compat = REVERSE.get(name);
        return compat != null ? compat : NONE;
    }

    protected SchemaCompatibilityResult validateAndCheck(Schema valueSchema, Schema currentSchema) {
        if (currentSchema == null && valueSchema == null) {
            return new SchemaCompatibilityResult(false, SchemaIncompatibilityType.NA);
        }
        if (currentSchema == valueSchema) {
            return new SchemaCompatibilityResult(false, SchemaIncompatibilityType.NA);
        }
        if (currentSchema == null || valueSchema == null) {
            throw new SchemaProjectorException("Switch between schema-based and schema-less data is not supported");
        }
        if ((valueSchema.version() == null || currentSchema.version() == null) && this != NONE) {
            throw new SchemaProjectorException("Schema version required for " + this.toString() + " compatibility");
        }
        return this.check(valueSchema, currentSchema);
    }

    protected SchemaCompatibilityResult check(Schema originalSchema, Schema currentSchema) {
        if (this.checkSchemaTypes(originalSchema, currentSchema)) {
            return new SchemaCompatibilityResult(true, SchemaIncompatibilityType.DIFFERENT_TYPE);
        }
        if (this.checkSchemaNames(originalSchema, currentSchema)) {
            return new SchemaCompatibilityResult(true, SchemaIncompatibilityType.DIFFERENT_NAME);
        }
        if (this.checkSchemaParameters(originalSchema, currentSchema)) {
            return new SchemaCompatibilityResult(true, SchemaIncompatibilityType.DIFFERENT_PARAMS);
        }
        return this.checkVersions(originalSchema, currentSchema);
    }

    protected SchemaCompatibilityResult checkVersions(Schema originalSchema, Schema currentSchema) {
        boolean isInCompatible = originalSchema.version().compareTo(currentSchema.version()) > 0;
        SchemaIncompatibilityType schemaIncompatibilityType = isInCompatible ? SchemaIncompatibilityType.DIFFERENT_VERSION : SchemaIncompatibilityType.NA;
        return new SchemaCompatibilityResult(isInCompatible, schemaIncompatibilityType);
    }

    protected boolean checkSchemaTypes(Schema originalSchema, Schema currentSchema) {
        return originalSchema.type() != currentSchema.type() && !this.isPromotable(originalSchema.type(), currentSchema.type());
    }

    protected boolean checkSchemaNames(Schema originalSchema, Schema currentSchema) {
        return !Objects.equals(originalSchema.name(), currentSchema.name());
    }

    protected boolean checkSchemaParameters(Schema originalSchema, Schema currentSchema) {
        return !Objects.equals(originalSchema.parameters(), currentSchema.parameters());
    }

    protected boolean isPromotable(Schema.Type sourceType, Schema.Type targetType) {
        return PROMOTABLES.contains(new AbstractMap.SimpleImmutableEntry<Schema.Type, Schema.Type>(sourceType, targetType));
    }

    @Override
    public SchemaCompatibilityResult shouldChangeSchema(ConnectRecord<?> record, Schema currentKeySchema, Schema currentValueSchema) {
        return this.validateAndCheck(record.valueSchema(), currentValueSchema);
    }

    @Override
    public SourceRecord project(SourceRecord record, Schema currentKeySchema, Schema currentValueSchema) {
        Map.Entry<Object, Object> projected = StorageSchemaCompatibility.projectInternal(record, currentKeySchema, currentValueSchema);
        return projected.getKey() == record.key() && projected.getValue() == record.value() ? record : new SourceRecord(record.sourcePartition(), record.sourceOffset(), record.topic(), record.kafkaPartition(), currentKeySchema, projected.getKey(), currentValueSchema, projected.getValue(), record.timestamp());
    }

    @Override
    public SinkRecord project(SinkRecord record, Schema currentKeySchema, Schema currentValueSchema) {
        Map.Entry<Object, Object> projected = StorageSchemaCompatibility.projectInternal(record, currentKeySchema, currentValueSchema);
        if (projected.getKey() == record.key() && projected.getValue() == record.value()) {
            return record;
        }
        return record.newRecord(record.topic(), record.kafkaPartition(), currentKeySchema, projected.getKey(), currentValueSchema, projected.getValue(), record.timestamp());
    }

    private static Map.Entry<Object, Object> projectInternal(ConnectRecord<?> record, Schema currentKeySchema, Schema currentValueSchema) {
        Object value = StorageSchemaCompatibility.projectInternal(record.valueSchema(), record.value(), currentValueSchema);
        return new AbstractMap.SimpleEntry<Object, Object>(record.key(), value);
    }

    private static Object projectInternal(Schema originalSchema, Object value, Schema currentSchema) {
        if (Objects.equals(originalSchema, currentSchema)) {
            return value;
        }
        return SchemaProjector.project((Schema)originalSchema, (Object)value, (Schema)currentSchema);
    }

    static {
        REVERSE = new HashMap<String, StorageSchemaCompatibility>();
        for (StorageSchemaCompatibility compat : StorageSchemaCompatibility.values()) {
            REVERSE.put(compat.name(), compat);
        }
        Schema.Type[] promotableTypes = new Schema.Type[]{Schema.Type.INT8, Schema.Type.INT16, Schema.Type.INT32, Schema.Type.INT64, Schema.Type.FLOAT32, Schema.Type.FLOAT64};
        HashSet<AbstractMap.SimpleImmutableEntry<Schema.Type, Schema.Type>> entries = new HashSet<AbstractMap.SimpleImmutableEntry<Schema.Type, Schema.Type>>();
        for (int i = 0; i < promotableTypes.length; ++i) {
            for (int j = i; j < promotableTypes.length; ++j) {
                entries.add(new AbstractMap.SimpleImmutableEntry<Schema.Type, Schema.Type>(promotableTypes[i], promotableTypes[j]));
            }
        }
        PROMOTABLES = Collections.unmodifiableSet(entries);
    }
}

