/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.storage;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.sink.ErrantRecordReporter;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.sink.SinkTaskContext;
import org.junit.After;

public class StorageSinkTestBase {
    protected static final String TOPIC = "test-topic";
    protected static final int PARTITION = 12;
    protected static final int PARTITION2 = 13;
    protected static final int PARTITION3 = 14;
    protected static final TopicPartition TOPIC_PARTITION = new TopicPartition("test-topic", 12);
    protected static final TopicPartition TOPIC_PARTITION2 = new TopicPartition("test-topic", 13);
    protected static final TopicPartition TOPIC_PARTITION3 = new TopicPartition("test-topic", 14);
    protected static final long TIMESTAMP = 12L;
    protected Map<String, String> properties;
    protected String url;
    protected MockSinkTaskContext context;

    protected Map<String, String> createProps() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("store.url", this.url);
        props.put("flush.size", "3");
        return props;
    }

    protected String generateEncodedPartitionFromMap(Map<String, Object> fieldMapping) {
        String delim = "/";
        return Utils.mkString(fieldMapping, (String)"", (String)"", (String)"=", (String)delim);
    }

    protected Schema createSchema() {
        return SchemaBuilder.struct().name("record").version(Integer.valueOf(1)).field("boolean", Schema.BOOLEAN_SCHEMA).field("int", Schema.INT32_SCHEMA).field("long", Schema.INT64_SCHEMA).field("float", Schema.FLOAT32_SCHEMA).field("double", Schema.FLOAT64_SCHEMA).build();
    }

    protected Struct createRecord(Schema schema) {
        return new Struct(schema).put("boolean", (Object)true).put("int", (Object)12).put("long", (Object)12L).put("float", (Object)Float.valueOf(12.2f)).put("double", (Object)12.2);
    }

    protected Schema createNewSchema() {
        return SchemaBuilder.struct().name("record").version(Integer.valueOf(2)).field("boolean", Schema.BOOLEAN_SCHEMA).field("int", Schema.INT32_SCHEMA).field("long", Schema.INT64_SCHEMA).field("float", Schema.FLOAT32_SCHEMA).field("double", Schema.FLOAT64_SCHEMA).field("string", SchemaBuilder.string().defaultValue((Object)"abc").build()).build();
    }

    protected Struct createNewRecord(Schema newSchema) {
        return new Struct(newSchema).put("boolean", (Object)true).put("int", (Object)12).put("long", (Object)12L).put("float", (Object)Float.valueOf(12.2f)).put("double", (Object)12.2).put("string", (Object)"def");
    }

    protected Schema createSchemaNoVersion() {
        return SchemaBuilder.struct().name("record").field("boolean", Schema.BOOLEAN_SCHEMA).field("int", Schema.INT32_SCHEMA).field("long", Schema.INT64_SCHEMA).field("float", Schema.FLOAT32_SCHEMA).field("double", Schema.FLOAT64_SCHEMA).build();
    }

    protected Schema createSchemaWithTimestampField() {
        return this.createSchemaWithTimestampField(Schema.INT64_SCHEMA);
    }

    protected Schema createSchemaWithTimestampField(Schema timestampSchema) {
        return SchemaBuilder.struct().name("record").version(Integer.valueOf(1)).field("boolean", Schema.BOOLEAN_SCHEMA).field("int", Schema.INT32_SCHEMA).field("long", Schema.INT64_SCHEMA).field("float", Schema.FLOAT32_SCHEMA).field("double", Schema.FLOAT64_SCHEMA).field("string", SchemaBuilder.string().defaultValue((Object)"abc").build()).field("timestamp", timestampSchema).build();
    }

    protected Struct createRecordWithTimestampField(Schema newSchema, long timestamp) {
        return this.createRecordWithTimestampField(newSchema, (Object)timestamp);
    }

    protected Struct createRecordWithTimestampField(Schema newSchema, Object timestamp) {
        return new Struct(newSchema).put("boolean", (Object)true).put("int", (Object)12).put("long", (Object)12L).put("float", (Object)Float.valueOf(12.2f)).put("double", (Object)12.2).put("string", (Object)"def").put("timestamp", timestamp);
    }

    protected Struct createRecordWithNestedTimestampField(long timestamp) {
        Schema nestedChildSchema = this.createSchemaWithTimestampField();
        SchemaBuilder nestedSchema = SchemaBuilder.struct().field("nested", nestedChildSchema);
        return new Struct((Schema)nestedSchema).put("nested", (Object)this.createRecordWithTimestampField(nestedChildSchema, timestamp));
    }

    protected Map<String, Object> createMapWithTimestampField(long timestamp) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("boolean", true);
        m.put("int", 12);
        m.put("long", 12L);
        m.put("float", Float.valueOf(12.2f));
        m.put("double", 12.2);
        m.put("string", "def");
        m.put("timestamp", timestamp);
        return m;
    }

    protected SinkRecord createSinkRecord(long timestamp) {
        Schema schema = this.createSchemaWithTimestampField();
        Struct record = this.createRecordWithTimestampField(schema, timestamp);
        return new SinkRecord(TOPIC, 12, Schema.STRING_SCHEMA, null, schema, (Object)record, 0L, Long.valueOf(timestamp), TimestampType.CREATE_TIME);
    }

    protected SinkRecord createSinkRecordWithNestedTimestampField(long timestamp) {
        Struct record = this.createRecordWithNestedTimestampField(timestamp);
        return new SinkRecord(TOPIC, 12, Schema.STRING_SCHEMA, null, record.schema(), (Object)record, 0L, Long.valueOf(timestamp), TimestampType.CREATE_TIME);
    }

    public void setUp() throws Exception {
        this.properties = this.createProps();
        HashSet<TopicPartition> assignment = new HashSet<TopicPartition>();
        assignment.add(TOPIC_PARTITION);
        assignment.add(TOPIC_PARTITION2);
        this.context = new MockSinkTaskContext(assignment);
    }

    @After
    public void tearDown() throws Exception {
    }

    protected static class MockSinkTaskContext
    implements SinkTaskContext {
        private final Map<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
        private long timeoutMs = -1L;
        private Set<TopicPartition> assignment;

        public MockSinkTaskContext(Set<TopicPartition> assignment) {
            this.assignment = assignment;
        }

        public Map<String, String> configs() {
            throw new UnsupportedOperationException();
        }

        public void offset(Map<TopicPartition, Long> offsets) {
            this.offsets.putAll(offsets);
        }

        public void offset(TopicPartition tp, long offset) {
            this.offsets.put(tp, offset);
        }

        public Map<TopicPartition, Long> offsets() {
            return this.offsets;
        }

        public void timeout(long timeoutMs) {
            this.timeoutMs = timeoutMs;
        }

        public long timeout() {
            return this.timeoutMs;
        }

        public Set<TopicPartition> assignment() {
            return this.assignment;
        }

        public void setAssignment(Set<TopicPartition> nextAssignment) {
            this.assignment = nextAssignment;
        }

        public void pause(TopicPartition ... partitions) {
        }

        public void resume(TopicPartition ... partitions) {
        }

        public void requestCommit() {
        }

        public ErrantRecordReporter errantRecordReporter() {
            throw new UnsupportedOperationException("ErrantRecordReporter is undefined for this class");
        }
    }
}

