/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.storage;

import io.confluent.connect.avro.AvroDataConfig;
import io.confluent.connect.storage.common.ComposableConfig;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class StorageSinkConnectorConfig
extends AbstractConfig
implements ComposableConfig {
    public static final String FORMAT_CLASS_CONFIG = "format.class";
    public static final String FORMAT_CLASS_DOC = "The format class to use when writing data to the store.";
    public static final String FORMAT_CLASS_DISPLAY = "Format class";
    public static final String FLUSH_SIZE_CONFIG = "flush.size";
    public static final String FLUSH_SIZE_DOC = "Number of records written to store before invoking file commits.";
    public static final String FLUSH_SIZE_DISPLAY = "Flush Size";
    public static final String ROTATE_INTERVAL_MS_CONFIG = "rotate.interval.ms";
    public static final String ROTATE_INTERVAL_MS_DOC = "The time interval in milliseconds to invoke file commits. You can configure this parameter so that the time interval is determined by using a timestamp extractor (for example, Kafka Record Time, Record Field, or Wall Clock extractor). When the first record is processed, a timestamp is set as the base time. This is useful if you require exactly-once-semantics. This configuration ensures that file commits are invoked at every configured interval. The default value ``-1`` indicates that this feature is disabled.";
    public static final long ROTATE_INTERVAL_MS_DEFAULT = -1L;
    public static final String ROTATE_INTERVAL_MS_DISPLAY = "Rotate Interval (ms)";
    public static final String ROTATE_SCHEDULE_INTERVAL_MS_CONFIG = "rotate.schedule.interval.ms";
    public static final String ROTATE_SCHEDULE_INTERVAL_MS_DOC = "The time interval in milliseconds to periodically invoke file commits. This configuration ensures that file commits are invoked at every configured interval. Time of commit will be adjusted to 00:00 of selected timezone. The commit will be performed at the scheduled time, regardless of the previous commit time or number of messages. This configuration is useful when you have to commit your data based on current server time, for example at the beginning of every hour. The default value ``-1`` means that this feature is disabled.";
    public static final long ROTATE_SCHEDULE_INTERVAL_MS_DEFAULT = -1L;
    public static final String ROTATE_SCHEDULE_INTERVAL_MS_DISPLAY = "Rotate Schedule Interval (ms)";
    public static final String RETRY_BACKOFF_CONFIG = "retry.backoff.ms";
    public static final String RETRY_BACKOFF_DOC = "The retry backoff in milliseconds. This config is used to notify Kafka connect to retry delivering a message batch or performing recovery in case of transient exceptions.";
    public static final long RETRY_BACKOFF_DEFAULT = 5000L;
    public static final String RETRY_BACKOFF_DISPLAY = "Retry Backoff (ms)";
    public static final String SHUTDOWN_TIMEOUT_CONFIG = "shutdown.timeout.ms";
    public static final String SHUTDOWN_TIMEOUT_DOC = "Clean shutdown timeout. This makes sure that asynchronous Hive metastore updates are completed during connector shutdown.";
    public static final long SHUTDOWN_TIMEOUT_DEFAULT = 3000L;
    public static final String SHUTDOWN_TIMEOUT_DISPLAY = "Shutdown Timeout (ms)";
    public static final String FILENAME_OFFSET_ZERO_PAD_WIDTH_CONFIG = "filename.offset.zero.pad.width";
    public static final String FILENAME_OFFSET_ZERO_PAD_WIDTH_DOC = "Width to zero pad offsets in store's filenames if offsets are too short in order to provide fixed width filenames that can be ordered by simple lexicographic sorting.";
    public static final int FILENAME_OFFSET_ZERO_PAD_WIDTH_DEFAULT = 10;
    public static final String FILENAME_OFFSET_ZERO_PAD_WIDTH_DISPLAY = "Filename Offset Zero Pad Width";
    public static final String SCHEMA_CACHE_SIZE_CONFIG = "schemas.cache.config";
    public static final String SCHEMA_CACHE_SIZE_DOC = "The size of the schema cache used in the Avro converter.";
    public static final int SCHEMA_CACHE_SIZE_DEFAULT = 1000;
    public static final String SCHEMA_CACHE_SIZE_DISPLAY = "Schema Cache Size";
    public static final String ENHANCED_AVRO_SCHEMA_SUPPORT_CONFIG = "enhanced.avro.schema.support";
    public static final boolean ENHANCED_AVRO_SCHEMA_SUPPORT_DEFAULT = true;
    public static final String ENHANCED_AVRO_SCHEMA_SUPPORT_DOC = "Enable enhanced avro schema support in AvroConverter: Enum symbol preservation and Package Name awareness";
    public static final String ENHANCED_AVRO_SCHEMA_SUPPORT_DISPLAY = "Enhanced Avro Support";
    public static final String CONNECT_META_DATA_CONFIG = "connect.meta.data";
    public static final boolean CONNECT_META_DATA_DEFAULT = true;
    public static final String CONNECT_META_DATA_DOC = "Allow connect converter to add its metadata to the output schema";
    public static final String CONNECT_META_DATA_DISPLAY = "Connect Metadata";
    public static final String AVRO_CODEC_CONFIG = "avro.codec";
    public static final String AVRO_CODEC_DEFAULT = "null";
    public static final String AVRO_CODEC_DISPLAY = "Avro Compression Codec";
    public static final String AVRO_CODEC_DOC = "The Avro compression codec to be used for output  files. Available values: null, deflate, snappy and bzip2 (CodecSource is org.apache.avro.file.CodecFactory)";
    public static final String[] AVRO_SUPPORTED_CODECS = new String[]{"null", "deflate", "snappy", "bzip2"};
    public static final String PARQUET_CODEC_CONFIG = "parquet.codec";
    public static final String PARQUET_CODEC_DEFAULT = "snappy";
    public static final String PARQUET_CODEC_DISPLAY = "Parquet Compression Codec";
    public static final String PARQUET_CODEC_DOC = "The Parquet compression codec to be used for output files.";
    private static final String ALLOW_OPTIONAL_MAP_KEYS_DISPLAY = "Allow Optional Map Keys";
    private static final String ALLOW_OPTIONAL_MAP_KEYS = "allow.optional.map.keys";
    private static final boolean ALLOW_OPTIONAL_MAP_KEYS_DEFAULT = false;
    public static final String ALLOW_OPTIONAL_MAP_KEYS_DOC = "Allow optional string map key when converting from Connect Schema to Avro Schema.";
    public static final String SCHEMA_COMPATIBILITY_CONFIG = "schema.compatibility";
    public static final String SCHEMA_COMPATIBILITY_DOC = "The schema compatibility rule to use when the connector is observing schema changes. The supported configurations are NONE, BACKWARD, FORWARD and FULL.";
    public static final String SCHEMA_COMPATIBILITY_DEFAULT = "NONE";
    public static final String SCHEMA_COMPATIBILITY_DISPLAY = "Schema Compatibility";
    public static final ConfigDef.Recommender schemaCompatibilityRecommender = new SchemaCompatibilityRecommender();

    public static ConfigDef newConfigDef(ConfigDef.Recommender formatClassRecommender, ConfigDef.Recommender avroRecommender) {
        ConfigDef configDef = new ConfigDef();
        String group = "Connector";
        int orderInGroup = 0;
        configDef.define(FORMAT_CLASS_CONFIG, ConfigDef.Type.CLASS, ConfigDef.Importance.HIGH, FORMAT_CLASS_DOC, "Connector", ++orderInGroup, ConfigDef.Width.NONE, FORMAT_CLASS_DISPLAY, formatClassRecommender);
        configDef.define(FLUSH_SIZE_CONFIG, ConfigDef.Type.INT, ConfigDef.Importance.HIGH, FLUSH_SIZE_DOC, "Connector", ++orderInGroup, ConfigDef.Width.LONG, FLUSH_SIZE_DISPLAY);
        configDef.define(ROTATE_INTERVAL_MS_CONFIG, ConfigDef.Type.LONG, (Object)-1L, ConfigDef.Importance.HIGH, ROTATE_INTERVAL_MS_DOC, "Connector", ++orderInGroup, ConfigDef.Width.MEDIUM, ROTATE_INTERVAL_MS_DISPLAY);
        configDef.define(ROTATE_SCHEDULE_INTERVAL_MS_CONFIG, ConfigDef.Type.LONG, (Object)-1L, ConfigDef.Importance.MEDIUM, ROTATE_SCHEDULE_INTERVAL_MS_DOC, "Connector", ++orderInGroup, ConfigDef.Width.MEDIUM, ROTATE_SCHEDULE_INTERVAL_MS_DISPLAY);
        configDef.define(SCHEMA_CACHE_SIZE_CONFIG, ConfigDef.Type.INT, (Object)1000, ConfigDef.Importance.LOW, SCHEMA_CACHE_SIZE_DOC, "Connector", ++orderInGroup, ConfigDef.Width.LONG, SCHEMA_CACHE_SIZE_DISPLAY);
        configDef.define(ENHANCED_AVRO_SCHEMA_SUPPORT_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, ENHANCED_AVRO_SCHEMA_SUPPORT_DOC, "Connector", ++orderInGroup, ConfigDef.Width.SHORT, ENHANCED_AVRO_SCHEMA_SUPPORT_DISPLAY);
        configDef.define(CONNECT_META_DATA_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, CONNECT_META_DATA_DOC, "Connector", ++orderInGroup, ConfigDef.Width.SHORT, CONNECT_META_DATA_DISPLAY);
        configDef.define(RETRY_BACKOFF_CONFIG, ConfigDef.Type.LONG, (Object)5000L, ConfigDef.Importance.LOW, RETRY_BACKOFF_DOC, "Connector", ++orderInGroup, ConfigDef.Width.MEDIUM, RETRY_BACKOFF_DISPLAY);
        configDef.define(SHUTDOWN_TIMEOUT_CONFIG, ConfigDef.Type.LONG, (Object)3000L, ConfigDef.Importance.MEDIUM, SHUTDOWN_TIMEOUT_DOC, "Connector", ++orderInGroup, ConfigDef.Width.MEDIUM, SHUTDOWN_TIMEOUT_DISPLAY);
        configDef.define(FILENAME_OFFSET_ZERO_PAD_WIDTH_CONFIG, ConfigDef.Type.INT, (Object)10, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, FILENAME_OFFSET_ZERO_PAD_WIDTH_DOC, "Connector", ++orderInGroup, ConfigDef.Width.LONG, FILENAME_OFFSET_ZERO_PAD_WIDTH_DISPLAY);
        configDef.define(AVRO_CODEC_CONFIG, ConfigDef.Type.STRING, (Object)AVRO_CODEC_DEFAULT, (ConfigDef.Validator)ConfigDef.ValidString.in((String[])AVRO_SUPPORTED_CODECS), ConfigDef.Importance.LOW, AVRO_CODEC_DOC, "Connector", ++orderInGroup, ConfigDef.Width.MEDIUM, AVRO_CODEC_DISPLAY, avroRecommender);
        configDef.define(ALLOW_OPTIONAL_MAP_KEYS, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, ALLOW_OPTIONAL_MAP_KEYS_DOC, "Connector", ++orderInGroup, ConfigDef.Width.SHORT, ALLOW_OPTIONAL_MAP_KEYS_DISPLAY);
        group = "Schema";
        orderInGroup = 0;
        configDef.define(SCHEMA_COMPATIBILITY_CONFIG, ConfigDef.Type.STRING, (Object)SCHEMA_COMPATIBILITY_DEFAULT, ConfigDef.Importance.HIGH, SCHEMA_COMPATIBILITY_DOC, "Schema", ++orderInGroup, ConfigDef.Width.SHORT, SCHEMA_COMPATIBILITY_DISPLAY, schemaCompatibilityRecommender);
        return configDef;
    }

    public static <T extends ConfigDef.Recommender & ConfigDef.Validator> void enableParquetConfig(ConfigDef configDef, T parquetRecommender, String group, int initialOrder) {
        int orderInGroup = initialOrder;
        configDef.define(PARQUET_CODEC_CONFIG, ConfigDef.Type.STRING, (Object)PARQUET_CODEC_DEFAULT, (ConfigDef.Validator)parquetRecommender, ConfigDef.Importance.LOW, PARQUET_CODEC_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, PARQUET_CODEC_DISPLAY, parquetRecommender);
    }

    public String getAvroCodec() {
        return this.getString(AVRO_CODEC_CONFIG);
    }

    public Object get(String key) {
        return super.get(key);
    }

    public StorageSinkConnectorConfig(ConfigDef configDef, Map<String, String> props) {
        super(configDef, props);
    }

    public AvroDataConfig avroDataConfig() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(SCHEMA_CACHE_SIZE_CONFIG, this.get(SCHEMA_CACHE_SIZE_CONFIG));
        props.put(ENHANCED_AVRO_SCHEMA_SUPPORT_CONFIG, this.get(ENHANCED_AVRO_SCHEMA_SUPPORT_CONFIG));
        props.put(CONNECT_META_DATA_CONFIG, this.get(CONNECT_META_DATA_CONFIG));
        props.put(ALLOW_OPTIONAL_MAP_KEYS, this.get(ALLOW_OPTIONAL_MAP_KEYS));
        return new AvroDataConfig(props);
    }

    public static class BooleanParentRecommender
    implements ConfigDef.Recommender {
        protected final String parentConfigName;

        public BooleanParentRecommender(String parentConfigName) {
            this.parentConfigName = parentConfigName;
        }

        public List<Object> validValues(String name, Map<String, Object> connectorConfigs) {
            return new LinkedList<Object>();
        }

        public boolean visible(String name, Map<String, Object> connectorConfigs) {
            return (Boolean)connectorConfigs.get(this.parentConfigName);
        }
    }

    public static class SchemaCompatibilityRecommender
    extends BooleanParentRecommender {
        public SchemaCompatibilityRecommender() {
            super("hive.integration");
        }

        @Override
        public List<Object> validValues(String name, Map<String, Object> connectorConfigs) {
            Boolean hiveIntegration = (Boolean)connectorConfigs.get(this.parentConfigName);
            if (hiveIntegration != null && hiveIntegration.booleanValue()) {
                return Arrays.asList("BACKWARD", "FORWARD", "FULL");
            }
            return Arrays.asList(StorageSinkConnectorConfig.SCHEMA_COMPATIBILITY_DEFAULT, "BACKWARD", "FORWARD", "FULL");
        }

        @Override
        public boolean visible(String name, Map<String, Object> connectorConfigs) {
            return true;
        }
    }
}

